//
//  SCBaseViewController.m
//  SocialCircle
//
//  Created by wu on 2024/2/21.
//

#import "SCBaseViewController.h"

@interface SCBaseViewController ()

@end

@implementation SCBaseViewController

- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleDefault;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    [self.navigationController setNavigationBarHidden:YES animated:NO];
    self.navTitle = [UILabel new];
    self.navTitle.text = @"标题";
    self.navTitle.textColor = [UIColor blackColor];
    self.navTitle.font = [UIFont systemFontOfSize:17];
    [self.view addSubview:self.navTitle];
    [self.navTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.view).offset([SCTools getAPPStatusBarHeight]+5);
    }];
    
    self.backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.backBtn.backgroundColor = [UIColor redColor];
    [self.backBtn addTarget:self action:@selector(backBtnClick) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.backBtn];
    [self.backBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view).offset(5);
        make.centerY.equalTo(self.navTitle);
        make.size.mas_equalTo(CGSizeMake(40, 40));
    }];
    
    UIView *bgView = [UIView new];
    bgView.backgroundColor = [SCTools colorWithHex:@"#f4f4f4"];
    bgView.hidden = YES;
    [self.view addSubview:bgView];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(self.view);
        make.top.equalTo(self.navTitle.mas_bottom).offset(15);
    }];
    self.bgView = bgView;
}

- (void)backBtnClick {
    [self.navigationController popViewControllerAnimated:YES];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
