//
//  SCAlertView.m
//  SocialCircle
//
//  Created by wu on 2024/2/22.
//

#import "SCAlertView.h"

@interface SCAlertView ()
@property (nonatomic,strong)UILabel *titleLabel;
@property (nonatomic,strong)UILabel *contentLabel;
@property (nonatomic,strong)UIButton *leftBtn;
@property (nonatomic,strong)UIButton *rightBtn;
@property (nonatomic,copy) void(^cancelHandler)(void);
@property (nonatomic,copy) void(^sureHandler)(void);

@end
@implementation SCAlertView
+ (void)showAlertWith:(NSString *)title content:(NSString *)content 
        cancelHandler:(void(^)(void))cancel
          sureHandler:(void(^)(void))sure {
    SCAlertView *alertView = [[SCAlertView alloc] initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)];
    alertView.cancelHandler = cancel;
    alertView.sureHandler = sure;
    alertView.titleLabel.text = title;
    alertView.contentLabel.text = content;
    [[UIApplication sharedApplication].delegate.window addSubview:alertView];
}
- (instancetype)initWithFrame:(CGRect)frame {
    if (self=[super initWithFrame:frame]) {
        self.backgroundColor = [SCTools colorWithHex:@"#000" alpha:0.7];
        UIView *bgView = [UIView new];
        bgView.backgroundColor = [UIColor whiteColor];
        bgView.layer.cornerRadius = 8.f;
        bgView.layer.masksToBounds = YES;
        [self addSubview:bgView];
        [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.centerY.equalTo(self);
            make.size.mas_equalTo(CGSizeMake(340, 200));
        }];
        
        self.titleLabel = [UILabel new];
        self.titleLabel.textColor = [SCTools colorWithHex:@"#333"];
        self.titleLabel.font = MEDIUMFONT(15);
        [bgView addSubview:self.titleLabel];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(bgView).offset(50);
            make.centerX.equalTo(bgView);
        }];
        
        self.contentLabel = [UILabel new];
        self.contentLabel.textColor = [SCTools colorWithHex:@"#666"];
        [bgView addSubview:self.contentLabel];
        [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.titleLabel.mas_bottom).offset(10);
            make.centerX.equalTo(bgView);
        }];
        
        self.leftBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.leftBtn setTitle:@"取消" forState:UIControlStateNormal];
        [self.leftBtn setTitleColor:[SCTools colorWithHex:@"#333"] forState:UIControlStateNormal];
        self.leftBtn.titleLabel.font = MEDIUMFONT(16);
        self.leftBtn.backgroundColor = [UIColor whiteColor];
        self.leftBtn.layer.cornerRadius = 6.f;
        self.leftBtn.layer.masksToBounds = YES;
        self.leftBtn.layer.borderWidth = 1.f;
        self.leftBtn.layer.borderColor = [SCTools colorWithHex:@"#333333"].CGColor;
        [self.leftBtn addTarget:self action:@selector(leftBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [bgView addSubview:self.leftBtn];
        [self.leftBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(bgView.mas_bottom).inset(15);
            make.left.equalTo(bgView).offset(12);
            make.size.mas_equalTo(CGSizeMake(150, 40));
        }];
        
        self.rightBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.rightBtn setTitle:@"确定" forState:UIControlStateNormal];
        [self.rightBtn setTitleColor:[SCTools colorWithHex:@"#333"] forState:UIControlStateNormal];
        self.rightBtn.titleLabel.font = MEDIUMFONT(16);
        self.rightBtn.backgroundColor = [UIColor blueColor];
        self.rightBtn.layer.cornerRadius = 6.f;
        self.rightBtn.layer.masksToBounds = YES;
        [self.rightBtn addTarget:self action:@selector(rightBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [bgView addSubview:self.rightBtn];
        [self.rightBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(bgView.mas_bottom).inset(15);
            make.right.equalTo(bgView).inset(12);
            make.size.mas_equalTo(CGSizeMake(150, 40));
        }];
        
        
    }
    return self;
}

- (void)leftBtnClick {
    if (self.cancelHandler) {
        self.cancelHandler();
    }
    [self removeFromSuperview];
}


- (void)rightBtnClick {
    if (self.sureHandler) {
        self.sureHandler();
    }
    [self removeFromSuperview];
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
