//
//  BlackListTableViewCell.m
//  SocialCircle
//
//  Created by wu on 2024/2/22.
//

#import "BlackListTableViewCell.h"
@interface BlackListTableViewCell()
@property(nonatomic,strong)UIImageView *headImageView;
@property(nonatomic,strong)UILabel *nickLabel;
@property(nonatomic,strong)UILabel *timeLabel;
@property(nonatomic,strong)UIButton *removeBtn;
@end
@implementation BlackListTableViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self=[super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.headImageView = [UIImageView new];
        self.headImageView.layer.cornerRadius = 30.f;
        self.headImageView.layer.masksToBounds = YES;
        self.headImageView.backgroundColor = [UIColor redColor];
        [self.contentView addSubview:self.headImageView];
        [self.headImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).offset(12);
            make.centerY.equalTo(self.contentView);
            make.size.mas_equalTo(CGSizeMake(60, 60));
        }];
        
        self.nickLabel = [UILabel new];
        self.nickLabel.text = @"昵称";
        self.nickLabel.textColor = [SCTools colorWithHex:@"#333333"];
        self.nickLabel.font = MEDIUMFONT(15);
        [self.contentView addSubview:self.nickLabel];
        [self.nickLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.headImageView.mas_right).offset(5);
            make.top.equalTo(self.headImageView).offset(10);
        }];
        
        
        self.timeLabel = [UILabel new];
        self.timeLabel.text = @"黑名单时间：2024-02-19 11:12";
        self.timeLabel.textColor = [SCTools colorWithHex:@"#999999"];
        self.timeLabel.font = SYSTEMFONT(12);
        [self.contentView addSubview:self.timeLabel];
        [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.nickLabel);
            make.top.equalTo(self.nickLabel.mas_bottom).offset(5);
        }];
        
        self.removeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.removeBtn setTitle:@"移除" forState:UIControlStateNormal];
        [self.removeBtn setTitleColor:[SCTools colorWithHex:@"#333"] forState:UIControlStateNormal];
        self.removeBtn.titleLabel.font = SYSTEMFONT(13);
        self.removeBtn.backgroundColor = [SCTools colorWithHex:@"#eee"];
        self.removeBtn.layer.cornerRadius = 4.f;
        self.removeBtn.layer.masksToBounds = YES;
        [self.contentView addSubview:self.removeBtn];
        [self.removeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(self.contentView);
            make.right.equalTo(self.contentView).inset(15);
            make.size.mas_equalTo(CGSizeMake(50, 20));
        }];
        
        UIView *lineView = [UIView new];
        lineView.backgroundColor = [SCTools colorWithHex:@"#e1e1e1"];
        [self.contentView addSubview:lineView];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.equalTo(self.contentView);
            make.height.mas_equalTo(0.5);
        }];
    }
    
    return self;
}
@end
