//
//  SettingTableViewCell.m
//  SocialCircle
//
//  Created by wu on 2024/2/22.
//

#import "SettingTableViewCell.h"

@implementation SettingTableViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self=[super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.leftLabel = [UILabel new];
        self.leftLabel.text = @"编辑资料";
        self.leftLabel.textColor = [SCTools colorWithHex:@"#333333"];
        self.leftLabel.font = MEDIUMFONT(15);
        [self.contentView addSubview:self.leftLabel];
        [self.leftLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).offset(30);
            make.centerY.equalTo(self.contentView);
        }];
        
        UIImageView *rightImg = [UIImageView new];
        rightImg.backgroundColor = [UIColor redColor];
        [self.contentView addSubview:rightImg];
        [rightImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.contentView).inset(20);
            make.centerY.equalTo(self.contentView);
            make.size.mas_equalTo(10);
        }];
        
        self.rightLabel = [UILabel new];
        self.rightLabel.text = @"22";
        self.rightLabel.textColor = [SCTools colorWithHex:@"#999"];
        self.rightLabel.font = SYSTEMFONT(13);
        [self.contentView addSubview:self.rightLabel];
        [self.rightLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.contentView).inset(30);
            make.centerY.equalTo(self.contentView);
        }];
        
        self.lineView = [UIView new];
        self.lineView.backgroundColor = [SCTools colorWithHex:@"#eee"];
        [self.contentView addSubview:self.lineView];
         [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).offset(15);
            make.right.equalTo(self.contentView.mas_right).inset(15);
            make.bottom.equalTo(self.contentView);
            make.height.mas_equalTo(0.5);
        }];
    }
    return self;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
