//
//  BlacklistViewController.m
//  SocialCircle
//
//  Created by wu on 2024/2/22.
//

#import "BlacklistViewController.h"
#import "BlackListTableViewCell.h"
@interface BlacklistViewController ()<UITableViewDelegate,UITableViewDataSource>
@property(nonatomic,strong) UITableView *blackTabelView;
@property(nonatomic,strong) NSMutableArray *blackArray;
@end

@implementation BlacklistViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.navTitle.text = @"黑名单";
    UITableView *blackTabelView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
    blackTabelView.delegate = self;
    blackTabelView.dataSource = self;
    blackTabelView.rowHeight = 80.f;
    blackTabelView.separatorStyle = 0;
    blackTabelView.backgroundColor = [SCTools colorWithHex:@"#f4f4f4"];
    [self.view addSubview:blackTabelView];
    self.blackTabelView = blackTabelView;
    [blackTabelView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(self.view);
        make.top.equalTo(self.bgView);
    }];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 10;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *identifier = @"BlackListTableViewCell";
    BlackListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        cell = [[BlackListTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
        tableView.showsVerticalScrollIndicator = NO;
    }
    cell.selectionStyle = 0;
    return cell;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
