//
//  LogoutViewController.m
//  SocialCircle
//
//  Created by wu on 2024/2/22.
//

#import "LogoutViewController.h"

@interface LogoutViewController ()
@property(nonatomic,strong)UIButton *selectBtn;
@end

@implementation LogoutViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navTitle.text = @"账号注销";
    self.bgView.hidden = NO;
    UIView *explainView = [UIView new];
    explainView.backgroundColor = [UIColor whiteColor];
    explainView.layer.cornerRadius = 10.f;
    explainView.layer.masksToBounds = YES;
    [self.view addSubview:explainView];
    
    UILabel *explainLabel = [UILabel new];
    explainLabel.text = @"账号注销说明";
    explainLabel.textColor = [SCTools colorWithHex:@"#333"];
    explainLabel.font = MEDIUMFONT(15);
    [self.view addSubview:explainLabel];
    [explainLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.bgView).offset(25);
        make.centerX.equalTo(self.view);
    }];
    
    UILabel *explainContent = [UILabel new];
    explainContent.text = @"账号注销后不可恢复，一经注销成功，您将无法再使用该账号，也无法处理该账号内一切相关内容";
    explainContent.textColor = [SCTools colorWithHex:@"#999999"];
    explainContent.font = SYSTEMFONT(13);
    explainContent.numberOfLines = 0;
    [self.view addSubview:explainContent];
    [explainContent mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(explainLabel.mas_bottom).offset(15);
        make.left.equalTo(self.view).offset(25);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    UILabel *clauselabel = [UILabel new];
    clauselabel.text = @"在提交注销申请前，请确认您已阅读并同意，自愿放弃以下相关内容";
    clauselabel.textColor = [SCTools colorWithHex:@"#333333"];
    clauselabel.font = MEDIUMFONT(15);
    clauselabel.numberOfLines = 0;
    [self.view addSubview:clauselabel];
    [clauselabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(explainContent.mas_bottom).offset(15);
        make.left.equalTo(self.view).offset(25);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    UIImageView *oneImg = [UIImageView new];
    oneImg.backgroundColor = [UIColor blueColor];
    oneImg.layer.cornerRadius = 10.f;
    oneImg.layer.masksToBounds = YES;
    [self.view addSubview:oneImg];
    [oneImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(clauselabel.mas_bottom).offset(15);
        make.left.equalTo(self.view).offset(25);
        make.size.mas_equalTo(CGSizeMake(20,20));
    }];
    
    UILabel *oneLabel = [UILabel new];
    oneLabel.text = @"个人资料清除";
    oneLabel.textColor = [SCTools colorWithHex:@"#333333"];
    oneLabel.font = MEDIUMFONT(15);
    [self.view addSubview:oneLabel];
    [oneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(oneImg);
        make.left.equalTo(oneImg.mas_right).offset(5);
    }];
    
    UILabel *oneContent = [UILabel new];
    oneContent.text = @"用户头像、昵称、简介、性别、出生日期等信息";
    oneContent.textColor = [SCTools colorWithHex:@"#999999"];
    oneContent.font = SYSTEMFONT(13);
    oneContent.numberOfLines = 2;
    [self.view addSubview:oneContent];
    [oneContent mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(oneLabel.mas_bottom).offset(5);;
        make.left.equalTo(oneLabel);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    UIImageView *twoImg = [UIImageView new];
    twoImg.backgroundColor = [UIColor blueColor];
    twoImg.layer.cornerRadius = 10.f;
    twoImg.layer.masksToBounds = YES;
    [self.view addSubview:twoImg];
    [twoImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(oneContent.mas_bottom).offset(20);
        make.left.equalTo(self.view).offset(25);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    UILabel *twoLabel = [UILabel new];
    twoLabel.text = @"社交关系清除";
    twoLabel.textColor = [SCTools colorWithHex:@"#333333"];
    twoLabel.font = MEDIUMFONT(15);
    [self.view addSubview:twoLabel];
    [twoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(twoImg);
        make.left.equalTo(twoImg.mas_right).offset(5);
    }];
    
    UILabel *twoContent = [UILabel new];
    twoContent.text = @"粉丝、关注、好友、黑名单等相关信息";
    twoContent.textColor = [SCTools colorWithHex:@"#999999"];
    twoContent.font = SYSTEMFONT(13);
    twoContent.numberOfLines = 2;
    [self.view addSubview:twoContent];
    [twoContent mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(twoLabel.mas_bottom).offset(5);;
        make.left.equalTo(twoLabel);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    UIImageView *threeImg = [UIImageView new];
    threeImg.backgroundColor = [UIColor blueColor];
    threeImg.layer.cornerRadius = 10.f;
    threeImg.layer.masksToBounds = YES;
    [self.view addSubview:threeImg];
    [threeImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(twoContent.mas_bottom).offset(20);
        make.left.equalTo(self.view).offset(25);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    UILabel *threeLabel = [UILabel new];
    threeLabel.text = @"权益及财产放弃";
    threeLabel.textColor = [SCTools colorWithHex:@"#333333"];
    threeLabel.font = MEDIUMFONT(15);
    [self.view addSubview:threeLabel];
    [threeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(threeImg);
        make.left.equalTo(threeImg.mas_right).offset(5);
    }];
    
    UILabel *threeContent = [UILabel new];
    threeContent.text = @"未消耗完仍申请注销，该账号下的全部权益，如会员权益，及财产，如金币、道具等，将视为自愿放弃";
    threeContent.textColor = [SCTools colorWithHex:@"#999999"];
    threeContent.font = SYSTEMFONT(13);
    threeContent.numberOfLines = 2;
    [self.view addSubview:threeContent];
    [threeContent mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(threeLabel.mas_bottom).offset(5);;
        make.left.equalTo(threeLabel);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    UIImageView *fourImg = [UIImageView new];
    fourImg.backgroundColor = [UIColor blueColor];
    fourImg.layer.cornerRadius = 10.f;
    fourImg.layer.masksToBounds = YES;
    [self.view addSubview:fourImg];
    [fourImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(threeContent.mas_bottom).offset(20);
        make.left.equalTo(self.view).offset(25);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    UILabel *fourLabel = [UILabel new];
    fourLabel.text = @"内容放弃";
    fourLabel.textColor = [SCTools colorWithHex:@"#333333"];
    fourLabel.font = MEDIUMFONT(15);
    [self.view addSubview:fourLabel];
    [fourLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(fourImg);
        make.left.equalTo(fourImg.mas_right).offset(5);
    }];
    
    UILabel *fourContent = [UILabel new];
    fourContent.text = @"该账号发布的和拥有的所有内容，如动态、相册等";
    fourContent.textColor = [SCTools colorWithHex:@"#999999"];
    fourContent.font = SYSTEMFONT(13);
    fourContent.numberOfLines = 2;
    [self.view addSubview:fourContent];
    [fourContent mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(fourLabel.mas_bottom).offset(5);;
        make.left.equalTo(fourLabel);
        make.right.equalTo(self.view.mas_right).inset(25);
    }];
    
    [explainView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view).offset(12);
        make.top.equalTo(self.bgView).offset(12);
        make.right.equalTo(self.view.mas_right).inset(12);
        make.bottom.equalTo(fourContent.mas_bottom).offset(20);
    }];
    
    
    UIButton *selectBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [selectBtn setImage:[UIImage imageNamed:@""] forState:UIControlStateNormal];
    [selectBtn setImage:[UIImage imageNamed:@""] forState:UIControlStateSelected];
    [self.view addSubview:selectBtn];
    self.selectBtn = selectBtn;
    [selectBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view).offset(60);
        make.top.equalTo(explainView.mas_bottom).offset(15);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    UILabel *protocolLabel = [UILabel new];
    protocolLabel.text = @"我已阅读并同意";
    protocolLabel.textColor = [SCTools colorWithHex:@"#999999"];
    protocolLabel.font = SYSTEMFONT(12);
    [self.view addSubview:protocolLabel];
    [protocolLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(selectBtn.mas_right).offset(3);
        make.centerY.equalTo(selectBtn);
    }];
    
    UIButton *protocolBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [protocolBtn setTitle:@"《注销账号说明》" forState:UIControlStateNormal];
    [protocolBtn setTitleColor:[SCTools colorWithHex:@"#666666"] forState:UIControlStateNormal];
    protocolBtn.titleLabel.font = MEDIUMFONT(13);
    [self.view addSubview:protocolBtn];
    [protocolBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(protocolLabel.mas_right).offset(3);
        make.centerY.equalTo(selectBtn);
    }];
    
    UILabel *alertlabel = [UILabel new];
    alertlabel.text = @"对注销行为带来的后果自行承担责任";
    alertlabel.font = SYSTEMFONT(12);
    alertlabel.textColor = [SCTools colorWithHex:@"#999999"];
    [self.view addSubview:alertlabel];
    [alertlabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(protocolLabel);
        make.top.equalTo(protocolLabel.mas_bottom).offset(5);
    }];
    
    UIButton *applyBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    applyBtn.backgroundColor = [UIColor blueColor];
    [applyBtn setTitle:@"申请注销" forState:UIControlStateNormal];
    [applyBtn setTitleColor:[SCTools colorWithHex:@"#ffffff"] forState:UIControlStateNormal];
    applyBtn.titleLabel.font = MEDIUMFONT(15);
    applyBtn.layer.cornerRadius = 6.f;
    applyBtn.layer.masksToBounds = YES;
    [applyBtn addTarget:self action:@selector(applyBtnClick) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:applyBtn];
    [applyBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(alertlabel.mas_bottom).offset(20);
        make.size.mas_equalTo(CGSizeMake(300, 40));
    }];
    
}

- (void)applyBtnClick {
    [SCAlertView showAlertWith:@"是否注销账号" content:@"(不可终止，不可恢复)" cancelHandler:^{
            
        } sureHandler:^{
            
        }];
    
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
