//
//  SCNetworkManager.m
//  SocialCircle
//
//  Created by wu on 2024/2/21.
//

#import "SCNetworkManager.h"
#import "AFHTTPSessionManager.h"
@interface SCNetworkManager ()

@end
@implementation SCNetworkManager

static AFHTTPSessionManager *manager;
+ (AFHTTPSessionManager *)scManager {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[AFHTTPSessionManager alloc] initWithBaseURL:[NSURL URLWithString:kBaseURL]];
        manager.requestSerializer =  [AFJSONRequestSerializer serializer];
        manager.responseSerializer.acceptableContentTypes = [NSSet setWithObjects:@"application/json",@"text/json",@"text/javascript", @"text/html", nil];
    });
    return manager;
}


+ (void)requetWith:(nonnull NSString *)path
              type:(RequestMethod)type
             param:(id)param
            header:(NSDictionary *)header
           success:(nonnull void (^)(SCResponse * _Nonnull __strong))success failure:(nonnull void (^)(void))failure {
    if(header){
        header = [NSMutableDictionary dictionaryWithDictionary:header];
    }else{
        header = [NSMutableDictionary dictionary];
    }
    [header setValue:[self getAppVersion] forKey:@"version"];
    if (type==GETRequest) {
        [[self scManager] GET:path 
                   parameters:param
                      headers:header
                     progress:nil
                      success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            if (success) {
                NSLog(@"responseObjectGET====%@",responseObject);
                SCResponse *res;
                if(![responseObject isKindOfClass:[NSDictionary class]])
                {
                    res = [SCResponse new];
                    res.code = 3840;
                    res.msg  = @"JSON text did not start with array or object and option to allow fragments not set";
                }else {
                    res = [SCResponse mj_objectWithKeyValues:responseObject];
                }
                success(res);
            }
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            NSLog(@"网络异常");
            failure();
        }];
    }else {
        [[self scManager] POST:path 
                    parameters:param
                       headers:header
                      progress:nil
                       success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            if (success) {
                NSLog(@"responseObjectPOST====%@",responseObject);
                SCResponse *res;
                if(![responseObject isKindOfClass:[NSDictionary class]])
                {
                    res = [SCResponse new];
                    res.code = 3840;
                    res.msg  = @"JSON text did not start with array or object and option to allow fragments not set";
                }else {
                    res = [SCResponse mj_objectWithKeyValues:responseObject];
                }
                success(res);
            }
        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
            NSLog(@"网络异常");
            failure();
        }];
    }
}

+ (NSString *)getAppVersion{
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString *app_Version = [infoDictionary objectForKey:@"CFBundleShortVersionString"];
    return app_Version;
}

@end
@interface SCResponse ()

@end

@implementation SCResponse



@end
